<?php
declare(strict_types=1);

/**
 * کلاس اتصال پایدار به دیتابیس با PDO برای عملکرد سریع.
 */

final class Database
{
    /** @var PDO|null */
    private static ?PDO $pdoInstance = null;

    /**
     * ایجاد و دریافت اتصال PDO مشترک.
     */
    public static function pdo(array $config): PDO
    {
        if (self::$pdoInstance instanceof PDO) {
            return self::$pdoInstance;
        }

        self::$pdoInstance = new PDO(
            $config['dsn'],
            $config['username'],
            $config['password'],
            $config['options'] ?? []
        );

        try {
            self::$pdoInstance->exec("SET time_zone = '+03:30'");
        } catch (Throwable $exception) {
            // اگر هاست از منطقه زمانی پشتیبانی نکرد، خطا را لاگ کن اما ادامه بده.
            error_log('Failed to set MySQL time_zone: ' . $exception->getMessage());
        }

        return self::$pdoInstance;
    }
}


